/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.ext.AuthorityInfoAccessExtension;
import oracle.security.crypto.cert.ext.AuthorityKeyIDExtension;
import oracle.security.crypto.cert.ext.BasicConstraintsExtension;
import oracle.security.crypto.cert.ext.CRLCertificateIssuerExtension;
import oracle.security.crypto.cert.ext.CRLDistPointExtension;
import oracle.security.crypto.cert.ext.CRLHoldInstructionExtension;
import oracle.security.crypto.cert.ext.CRLInvalidityDateExtension;
import oracle.security.crypto.cert.ext.CRLNumberExtension;
import oracle.security.crypto.cert.ext.CRLReasonExtension;
import oracle.security.crypto.cert.ext.CertificatePoliciesExtension;
import oracle.security.crypto.cert.ext.DeltaCRLIndicatorExtension;
import oracle.security.crypto.cert.ext.ExtKeyUsageExtension;
import oracle.security.crypto.cert.ext.IssuerAltNameExtension;
import oracle.security.crypto.cert.ext.IssuingDistPointExtension;
import oracle.security.crypto.cert.ext.KeyUsageExtension;
import oracle.security.crypto.cert.ext.NameConstraintsExtension;
import oracle.security.crypto.cert.ext.NetscapeCertTypeExtension;
import oracle.security.crypto.cert.ext.PolicyConstraintsExtension;
import oracle.security.crypto.cert.ext.SubjectAltNameExtension;
import oracle.security.crypto.cert.ext.SubjectKeyIDExtension;
import oracle.security.crypto.util.OIDManager;

class OIDRegistrar {
    private static OIDManager oidMgr = OIDManager.getOIDManager();

    private OIDRegistrar() {
    }

    public static void mapExtensions() {
        OIDRegistrar.mapX509SubjectKeyIDExtension();
        OIDRegistrar.mapX509KeyUsageExtension();
        OIDRegistrar.mapX509SubjectAltNameExtension();
        OIDRegistrar.mapX509IssuerAltNameExtension();
        OIDRegistrar.mapX509BasicConstraintsExtension();
        OIDRegistrar.mapX509CRLNumberExtension();
        OIDRegistrar.mapX509CRLReasonExtension();
        OIDRegistrar.mapX509CRLHoldInstructionExtension();
        OIDRegistrar.mapX509CRLInvalidityDateExtension();
        OIDRegistrar.mapX509DeltaCRLIndicatorExtension();
        OIDRegistrar.mapX509IssuingDistPointExtension();
        OIDRegistrar.mapX509CRLCertificateIssuerExtension();
        OIDRegistrar.mapX509NameConstraintsExtension();
        OIDRegistrar.mapX509CertificatePoliciesExtension();
        OIDRegistrar.mapX509AuthorityKeyIDExtension();
        OIDRegistrar.mapX509PolicyConstraintsExtension();
        OIDRegistrar.mapX509ExtKeyUsageExtension();
        OIDRegistrar.mapX509CRLDistPointExtension();
        OIDRegistrar.mapX509AuthorityInfoAccessExtension();
        OIDRegistrar.mapX509NetscapeCertTypeExtension();
    }

    public static void mapAttributeTypeNames() {
        oidMgr.setAttributeTypeName("CN", PKIX.id_at_commonName);
        oidMgr.setAttributeTypeName("L", PKIX.id_at_localityName);
        oidMgr.setAttributeTypeName("ST", PKIX.id_at_stateOrProvinceName);
        oidMgr.setAttributeTypeName("O", PKIX.id_at_organizationName);
        oidMgr.setAttributeTypeName("OU", PKIX.id_at_organizationalUnitName);
        oidMgr.setAttributeTypeName("C", PKIX.id_at_countryName);
        oidMgr.setAttributeTypeName("STREET", PKIX.id_at_streetAddress);
        oidMgr.setAttributeTypeName("DC", PKIX.id_domainComponent);
        oidMgr.setAttributeTypeName("UID", PKIX.id_userid);
        oidMgr.setAttributeTypeName("Email", PKIX.emailAddress);
        oidMgr.setAttributeTypeName("EmailAddress", PKIX.emailAddress);
        oidMgr.setAttributeTypeName("SERIALNUMBER", PKIX.id_at_serialNumber);
        oidMgr.setAttributeTypeName("DNQ", PKIX.id_at_dnQualifier);
    }

    private static void mapX509SubjectKeyIDExtension() {
        try {
            oidMgr.setMapping(PKIX.id_ce_subjectKeyIdentifier, "extension", SubjectKeyIDExtension.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void mapX509KeyUsageExtension() {
        try {
            oidMgr.setMapping(PKIX.id_ce_keyUsage, "extension", KeyUsageExtension.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void mapX509SubjectAltNameExtension() {
        try {
            oidMgr.setMapping(PKIX.id_ce_subjectAltName, "extension", SubjectAltNameExtension.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void mapX509IssuerAltNameExtension() {
        try {
            oidMgr.setMapping(PKIX.id_ce_issuerAltName, "extension", IssuerAltNameExtension.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void mapX509BasicConstraintsExtension() {
        try {
            oidMgr.setMapping(PKIX.id_ce_basicConstraints, "extension", BasicConstraintsExtension.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void mapX509CRLNumberExtension() {
        try {
            oidMgr.setMapping(PKIX.id_ce_cRLNumber, "extension", CRLNumberExtension.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void mapX509CRLReasonExtension() {
        try {
            oidMgr.setMapping(PKIX.id_ce_cRLReason, "extension", CRLReasonExtension.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void mapX509CRLHoldInstructionExtension() {
        try {
            oidMgr.setMapping(PKIX.id_ce_holdInstructionCode, "extension", CRLHoldInstructionExtension.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void mapX509CRLInvalidityDateExtension() {
        try {
            oidMgr.setMapping(PKIX.id_ce_invalidityDate, "extension", CRLInvalidityDateExtension.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void mapX509DeltaCRLIndicatorExtension() {
        try {
            oidMgr.setMapping(PKIX.id_ce_deltaCRLIndicator, "extension", DeltaCRLIndicatorExtension.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void mapX509IssuingDistPointExtension() {
        try {
            oidMgr.setMapping(PKIX.id_ce_issuingDistributionPoint, "extension", IssuingDistPointExtension.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void mapX509CRLCertificateIssuerExtension() {
        try {
            oidMgr.setMapping(PKIX.id_ce_certificateIssuer, "extension", CRLCertificateIssuerExtension.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void mapX509NameConstraintsExtension() {
        try {
            oidMgr.setMapping(PKIX.id_ce_nameConstraints, "extension", NameConstraintsExtension.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void mapX509CertificatePoliciesExtension() {
        try {
            oidMgr.setMapping(PKIX.id_ce_certificatePolicies, "extension", CertificatePoliciesExtension.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void mapX509AuthorityKeyIDExtension() {
        try {
            oidMgr.setMapping(PKIX.id_ce_authorityKeyIdentifier, "extension", AuthorityKeyIDExtension.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void mapX509PolicyConstraintsExtension() {
        try {
            oidMgr.setMapping(PKIX.id_ce_policyConstraints, "extension", PolicyConstraintsExtension.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void mapX509ExtKeyUsageExtension() {
        try {
            oidMgr.setMapping(PKIX.id_ce_extKeyUsage, "extension", ExtKeyUsageExtension.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void mapX509CRLDistPointExtension() {
        try {
            oidMgr.setMapping(PKIX.id_ce_cRLDistributionPoints, "extension", CRLDistPointExtension.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void mapX509AuthorityInfoAccessExtension() {
        try {
            oidMgr.setMapping(PKIX.id_pe_authorityInfoAccess, "extension", AuthorityInfoAccessExtension.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void mapX509NetscapeCertTypeExtension() {
        try {
            oidMgr.setMapping(PKIX.id_netscape_ce_type, "extension", NetscapeCertTypeExtension.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

