<!doctype html>
<html lang="es">
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import="javax.naming.Context,
				javax.naming.InitialContext, 
				javax.sql.DataSource, 
				java.sql.Connection,
				java.sql.Statement,
				java.sql.ResultSet,
				oracle.jdbc.driver.OracleDriver" %>

<h1>JNDI With Oracle test page</h1>

<p>Test that context class exists....</p>
<%
	Context initCtx = new InitialContext();
%>

<p>Check that the environment context can be loaded....</p>
<%
	Context envCtx = (Context) initCtx.lookup("java:comp/env");
%>

<p>Check if our JNDI exist jdbc/my_simple_oracle_jndi...</p>
<%
	DataSource jndi = (DataSource) envCtx.lookup("jdbc/my_simple_oracle_jndi");
%>

<p>Creamos una conexión de base de datos...</p>
<%
// Allocate and use a connection from the pool
Connection conn = jndi.getConnection();
%>

<p>Ejecutamos una consulta...</p>
<%
try( Statement cmd = conn.createStatement() ){
	ResultSet rs = cmd.executeQuery( "select count(*) total, systimestamp now from df_cmn_aum_xx_tsk_job" ); 
	rs.next();
	out.println( "<p>" + rs.getLong("total") + "</p>" );
	out.println( "<p>" + rs.getDate("now") + "</p>" );
}
%>

<p>Y finalmente cerramos la conexion....</p>
<%
// and finally, close the connection to be a good citizen
conn.close();
%>
</html>
