import java.io.Console;
import java.util.ArrayList;
import java.util.List;

import com.supermanhamuerto.rubik.Cube;
import com.supermanhamuerto.rubik.Cube22;
import com.supermanhamuerto.rubik.CubeLoader;
import com.supermanhamuerto.rubik.MoveRotateXLeft;
import com.supermanhamuerto.rubik.MoveRotateXRight;
import com.supermanhamuerto.rubik.MoveRotateYLeft;
import com.supermanhamuerto.rubik.MoveRotateYRight;
import com.supermanhamuerto.rubik.MoveRotateZLeft;
import com.supermanhamuerto.rubik.MoveRotateZRight;
import com.supermanhamuerto.rubik.Movement;
import com.supermanhamuerto.rubik.Solver;

public class App
{
    
    public static List<Movement> getPossibleMovs()
    {
        List<Movement> result = new ArrayList<Movement>();

        result.add( new MoveRotateXLeft(0,1) );
        result.add( new MoveRotateXLeft(3,2) );
        result.add( new MoveRotateXRight(0,1) );
        result.add( new MoveRotateXRight(3,2) );
        result.add( new MoveRotateYLeft(0,1) );
        result.add( new MoveRotateYLeft(3,2) );
        result.add( new MoveRotateYRight(0,1) );
        result.add( new MoveRotateYRight(3,2) );
        result.add( new MoveRotateZLeft(0,1) );
        result.add( new MoveRotateZLeft(3,2) );
        result.add( new MoveRotateZRight(0,1) );
        result.add( new MoveRotateZRight(3,2) );
        return result;
    }

    /**
     * @param args
     */
    public static void main(String[] args)
    {
        String cubeCorrect = "N";
        Cube currentCube = new Cube22();        
        
        Console console = System.console();
        if (console == null) {
            System.err.println("No console.");
            System.exit(1);
        }
        
        do
        {
            System.out.println("How to read the cube:");
            System.out.println("");
            System.out.println("   1. put the rubik cube in front of you.");
            System.out.println("   2. read the colors of the TOP LAYER, ");
            System.out.println("      as if you were reading a book or a novel.");
            System.out.println("      If you have this:");
            System.out.println("      +---+");
            System.out.println("      |R|G|");
            System.out.println("      |Y|W|");
            System.out.println("      +---+");
            System.out.println("      You must enter the string \"rgyw\"");
            String face1 = console.readLine("");
            System.out.println("   3. Now begin with the colors in front of you:");
            String face2 = console.readLine("");
            System.out.println("   4. continue reading the colors of the face behind the cube");
            String face3 = console.readLine("");
            System.out.println("   5. and then the colors in the face in the back of the cube");
            String face4 = console.readLine("");
            System.out.println("   6. next, the rigth (your right, not the cube's) colors");
            String face5 = console.readLine("");
            System.out.println("   7. and finnally, the colors of the left face ");
            String face6 = console.readLine("");
            
            CubeLoader cubeLoader = new CubeLoader();
            
            /**
             * How to read the cube:
             * 
             *      1. put the rubik cube in front of you.
             *      2. read the colors of the top layer, 
             *         as if you were reading a book or a novel.
             *         If you have this:
             *         +---+
             *         |R|G|
             *         |Y|W|
             *         +---+
             *         You must enter the string "rgyw"
             *      3. Now read the colors of the face in front of you
             *      4. continue reading the colors of the face behind the cube
             *      5. and then the colors in the face in the back of the cube
             *      6. next, the rigth (your right, not the cube's) colors
             *      7. and finnally, the colors of the left face
             */
            cubeLoader.setFaces(currentCube, face1, face2, face3, face4, face5, face6 );
            
            System.out.print( currentCube ); 
            
            Movement m1 = new MoveRotateXRight(0,1);
            Movement m2 = new MoveRotateXRight(3,2);
            m1.apply( currentCube );
            m2.apply( currentCube );
            System.out.print( currentCube );
            
            cubeCorrect = console.readLine("Is the cube correct (Y/n)?");
            
        }while( !("y".equalsIgnoreCase(cubeCorrect) || cubeCorrect.isEmpty()) );
        
//        String strDepth = "10";
//        CubeLoader cubeLoader = new CubeLoader();
//        cubeLoader.setFaces( currentCube, "bbbb", "rrrr", "ywgg", "vvvv", "yygy", "wwwg" );
        
        Solver solver = new Solver( currentCube, getPossibleMovs(), 10 );
        
        if( solver.solve() )
        {
            List<Movement> solution = solver.getSolution();
            for( Movement mov : solution )
            {
                System.out.println( mov );
            } // mov : solution
            // print out the solution
        }
        else
            System.out.println("no solution found");

    } // main()

}
