package com.supermanhamuerto.rubik;

public class MoveRotateXRight extends MoveRotate
{

    public MoveRotateXRight(int outerLayer, int innerLayer)
    {
        super(Axis.X, Rotation.CLOCKWISE, outerLayer, innerLayer);
    }
    
    /**
     * Rotate the top layer of the cube -> (this direction)
     */
    @Override
    public void apply( Cube c )
    {
        Color tmp; 
        // perform rotation on top layer
        tmp = c.getColor(outerLayer, 2, 1);
        c.setColor(outerLayer, 2, 1, c.getColor(outerLayer, 1, 1));
        c.setColor(outerLayer, 1, 1, c.getColor(outerLayer, 1, 2));
        c.setColor(outerLayer, 1, 2, c.getColor(outerLayer, 2, 2));
        c.setColor(outerLayer, 2, 2, tmp );
        // perform rotation of inner layer
        tmp = c.getColor(innerLayer, 2, 0 ); 
        c.setColor(innerLayer, 2, 0, c.getColor(innerLayer, 0, 1));
        c.setColor(innerLayer, 0, 1, c.getColor(innerLayer, 1, 3));
        c.setColor(innerLayer, 1, 3, c.getColor(innerLayer, 3, 2));
        c.setColor(innerLayer, 3, 2, tmp);
        tmp = c.getColor(innerLayer, 1, 0);
        c.setColor(innerLayer, 1, 0, c.getColor(innerLayer, 0, 2));
        c.setColor(innerLayer, 0, 2, c.getColor(innerLayer, 2, 3));
        c.setColor(innerLayer, 2, 3, c.getColor(innerLayer, 3, 1));
        c.setColor(innerLayer, 3, 1, tmp );
    }

}
