package com.supermanhamuerto.rubik;

public class MoveRotateYRight  extends MoveRotate
{

    public MoveRotateYRight(int outerLayer, int innerLayer)
    {
        super(Axis.Y, Rotation.CLOCKWISE, outerLayer, innerLayer);
    }
    
    /**
     * Rotate the top layer of the cube -> (this direction)
     */
    @Override
    public void apply( Cube c )
    {
        Color tmp; 
        // perform the rotation of the top layer
        tmp = c.getColor(1, outerLayer, 1);
        c.setColor(1, outerLayer, 1, c.getColor(1, outerLayer, 2));
        c.setColor(1, outerLayer, 2, c.getColor(2, outerLayer, 2));
        c.setColor(2, outerLayer, 2, c.getColor(2, outerLayer, 1));
        c.setColor(2, outerLayer, 1, tmp);
        
        // perform rotation of inner layer
        tmp = c.getColor( 1, innerLayer, 0);
        c.setColor(1, innerLayer, 0, c.getColor(0, innerLayer, 2));
        c.setColor(0, innerLayer, 2, c.getColor(2, innerLayer, 3));
        c.setColor(2, innerLayer, 3, c.getColor(3, innerLayer, 1));
        c.setColor(3, innerLayer, 1, tmp);
        tmp = c.getColor(2,  innerLayer, 0);
        c.setColor(2, innerLayer, 0, c.getColor(0, innerLayer, 1));
        c.setColor(0, innerLayer, 1, c.getColor(1, innerLayer, 3));
        c.setColor(1, innerLayer, 3, c.getColor(3, innerLayer, 2));
        c.setColor(3, innerLayer, 2, tmp );
        
    } // apply

}
