package com.supermanhamuerto.rubik;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class Solver
{
    private Cube cube; 
    private List<Movement> possibleMovs;
    private List<Movement> solution;
    private int depth; 
    
    public Solver( Cube cube, List<Movement> possibleMovs, int depth )
    {
        this.cube = cube;
        this.possibleMovs = possibleMovs;
        this.depth = depth;
    } // Solver
    
    public List<Movement> getSolution()
    {
        return this.solution;
    }
    
    public boolean solve()
    {
        Stack<Cube> pastStates = new Stack<Cube>();
        boolean isThereSolution;
        
        solution = new ArrayList<Movement>();
        isThereSolution = this.findSolution( pastStates, cube, solution, possibleMovs );
        
        if( isThereSolution )
        {
            Collections.reverse( solution );
            System.out.println("Solution found!!!");
        } // isThereSolution
        
        return isThereSolution;
    } // solve

    

    @SuppressWarnings("unused")
    private boolean findSolution2(Stack<Cube> pastStates, Cube currentState,
                                List<Movement> partialSolution, 
                                final List<Movement> possibleMovs)
    {
        // obvious case
        boolean solutionFound = currentState.isSolved();
        if (solutionFound)
            return true;

        // if we are reached an state who is in the
        // list of past states, this branch is exhausted
        if (pastStates.contains(currentState))
            return false;
        if (pastStates.size() > depth)
            return false;

        // anotate this temptative for discard it in the future
        // (for example, if we apply the same movement four times in a row)
        pastStates.push(currentState);

        // else is not solved
        // apply a movement and try to find a solution
        Iterator<Movement> itMov = possibleMovs.iterator();
        while (!solutionFound && itMov.hasNext())
        {
            Movement currentMov = itMov.next();
            // create a new cube copy of the currentState
            Cube temptativeSol = currentState.getCopy();
            currentMov.apply(temptativeSol);
            solutionFound = findSolution(pastStates, temptativeSol,
                    partialSolution, possibleMovs);

            if (solutionFound)
                partialSolution.add(currentMov);
        } // !solutionFound

        pastStates.pop();
        return solutionFound;
    } // findSolution
    
    private boolean findSolution( Stack<Cube> pastStates, 
                                  Cube currentState, 
                                  List<Movement> partialSolution, 
                                  final List<Movement> possibleMovs )
    {
        
        // obvious case
        boolean solutionFound = currentState.isSolved();
        if( solutionFound )
            return true;            
        
        // if we are reached an state who is in the 
        // list of past states, this branch is exhausted
        if( pastStates.contains( currentState ) )
            return false; 
        if( pastStates.size() > depth )
            return false; 
        
        // anotate this temptative for discard it in the future
        // (for example, if we apply the same movement four times in a row)
        pastStates.push( currentState );

        // else is not solved
        // apply a movement and try to find a solution
        Iterator<Movement> itMov = possibleMovs.iterator();
        while( !solutionFound && itMov.hasNext() )
        {
            Movement currentMov = itMov.next();
            // create a new cube copy of the currentState
            Cube temptativeSol = currentState.getCopy();
            currentMov.apply( temptativeSol );
            solutionFound = findSolution( pastStates, temptativeSol, partialSolution, possibleMovs );                
            
            if( solutionFound )
                partialSolution.add( currentMov );
        } // !solutionFound 
        
        pastStates.pop();
        return solutionFound;
    } // findSolution
    
    
    
}
