package com.supermanhamuerto.test;

/**
 * Examples and usage of javadoc tags. 
 * <br/>
 * <br/>
 * <table border="1" width="50%">
 * <tr>
 * <td><b>&#064;author</b> <i>some-text</i></td>
 * <td>To set the author. Javadoc will put this info at the end.</td>
 * </tr>
 * <tr>
 * <td><b>&#064;deprecated</b> <i>some-text</i></td>
 * <td>To inform that something is deprecated. Better put at the beginning</td>
 * </tr>
 * <tr>
 * <td>{<b>&#064;code</b> <i>some-text</i>}</td>
 * <td>Is the equivalent to &lt;code&gt;some-text&lt;/code&gt;. 
 * To insert code snippets in the comments.</td>
 * </tr>
 * <tr>
 * <td>{<b>&#064;docRoot</b>}</td>
 * <td>To refer to the "root" of this javadoc. For 
 * instance, to refer an image: &lt;img src="{&#064;docRoot}/some-image.png"&gt;</td>
 * </tr>
 * <tr>
 * <td>{<b>&#064;inheritDoc</b>}</td>
 * <td>To inherit the documentation from its nearest class. Useful
 * to copy more general comments from its parent classes and then 
 * copy to is derivated classes.</td>
 * </tr>
 * <tr>
 * <td>{<b>&#064;link</b> <i>package.class#member</i> <i>label</i>}</td>
 * <td>To create a link to another package, class, member. It 
 * will show a link with the text of the "label".</td>
 * </tr>
 * <tr>
 * <td>{<b>&#064;linkplain</b> <i>package.class#member</i> <i>label</i>}</td>
 * <td>The same as link, but the link will be shown with 
 * normal font instead of code font.</td>
 * </tr>
 * <tr>
 * <td>{<b>&#064;literal</b> text}</td>
 * <td>To include some text literally {&#064;literal 3 < 5 > 7} will output:
 * {literal 3 < 5 > 7}</td>
 * </tr>
 * <tr>
 * <td><b>&#064;param</b> <i>parameter-name</i> <i>description</i></td>
 * <td>To describe a parameter. Put it in a single line.</td>
 * </tr>
 * <tr>
 * <td><b>&#064;return</b> description</td>
 * <td>Adds a "Returns" section in the description, and is 
 * used to better describe the return of some method.</td>
 * </tr>
 * <tr>
 * <td><b>&#064;see</b> <i>reference</i></td>
 * <td>Adds a "See also" section in the description text. Forms 
 * of reference may be:
 * <ul>
 * 	<li><i>some-text</i> - to refer to a book, for instance
 *  <li><i>&lt;a href="some-url"&gt;some-label&lt;/a&gt;</i> - to refer to a web page
 *  <li><i>package.class#member label</i> - to refer to another method or class
 * </ul>
 * </td>
 * </tr>
 * <tr>
 * <td><b>&#064;serial</b></td>
 * <td></td>
 * </tr>
 * <tr>
 * <td><b>&#064;serialField</b></td>
 * <td></td>
 * </tr>
 * <tr>
 * <td><b>&#064;serialData</b></td>
 * <td></td>
 * </tr>
 * <tr>
 * <td><b>&#064;since</b> <i>since-text</i></td>
 * <td>This adds a "since" section in the documentation, with the 
 * specified since-text in it.</td>
 * </tr>
 * <tr>
 * <td><b>&#064;throws</b> <i>class-name</i> <i>description</i></td>
 * <td>To indicate that this method trows a particular exception.</td>
 * </tr>
 * <tr>
 * <td><b>{&#064;value</b> <i>package.class#field</i>}</td>
 * <td>Use to refer to a value of a static field</td>
 * </tr>
 * <tr>
 * <td><b>&#064;version</b> <i>version-text</i></td>
 * <td>To include a "version text" in the description.</td>
 * </tr>
 * </table>
 * 
 * @author rluna
 *
 */
public class Rectangle extends Shape {

}
