/*
 * Decompiled with CFR 0.152.
 */
package com.supermanhamuerto.rubik;

import com.supermanhamuerto.rubik.Axis;
import com.supermanhamuerto.rubik.Cube;
import com.supermanhamuerto.rubik.Movement;
import com.supermanhamuerto.rubik.Rotation;

public class MoveRotate
implements Movement {
    private static final String nl = System.getProperty("line.separator");
    private final Axis axis;
    private final Rotation rotation;
    protected int outerLayer;
    protected int innerLayer;

    public MoveRotate(Axis axis, Rotation rotation, int outerLayer, int innerLayer) {
        this.axis = axis;
        this.rotation = rotation;
        this.outerLayer = outerLayer;
        this.innerLayer = innerLayer;
    }

    public int getOuterLayer() {
        return this.outerLayer;
    }

    public int getInnerLayer() {
        return this.innerLayer;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    @Override
    public Movement getOposite() {
        if (this.rotation == Rotation.CLOCKWISE) {
            return new MoveRotate(this.axis, Rotation.COUNTERCLOCKWISE, this.outerLayer, this.innerLayer);
        }
        return new MoveRotate(this.axis, Rotation.CLOCKWISE, this.outerLayer, this.innerLayer);
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        switch (this.axis) {
            case X: {
                if (this.outerLayer == 0) {
                    if (this.rotation == Rotation.CLOCKWISE) {
                        out.append("+---+---+");
                        out.append(nl);
                        out.append("| | |   |");
                        out.append(nl);
                        out.append("+ | +---+");
                        out.append(nl);
                        out.append("| v |   |");
                        out.append(nl);
                        out.append("+---+---+");
                        out.append(nl);
                        break;
                    }
                    out.append("+---+---+");
                    out.append(nl);
                    out.append("| ^ |   |");
                    out.append(nl);
                    out.append("+ | +---+");
                    out.append(nl);
                    out.append("| | |   |");
                    out.append(nl);
                    out.append("+---+---+");
                    out.append(nl);
                    break;
                }
                if (this.rotation == Rotation.CLOCKWISE) {
                    out.append("+---+---+");
                    out.append(nl);
                    out.append("|   | | |");
                    out.append(nl);
                    out.append("+---+ | +");
                    out.append(nl);
                    out.append("|   | v |");
                    out.append(nl);
                    out.append("+---+---+");
                    out.append(nl);
                    break;
                }
                out.append("+---+---+");
                out.append(nl);
                out.append("|   | ^ |");
                out.append(nl);
                out.append("+---+ | +");
                out.append(nl);
                out.append("|   | | |");
                out.append(nl);
                out.append("+---+---+");
                out.append(nl);
                break;
            }
            case Y: {
                if (this.outerLayer == 0) {
                    if (this.rotation == Rotation.CLOCKWISE) {
                        out.append("    +---+---+");
                        out.append(nl);
                        out.append("   / --->  /");
                        out.append(nl);
                        out.append("   -------  ");
                        out.append(nl);
                        out.append(" /   /   /  ");
                        out.append(nl);
                        out.append("+---+---+   ");
                        out.append(nl);
                        break;
                    }
                    out.append("    +---+---+");
                    out.append(nl);
                    out.append("   / <---  /");
                    out.append(nl);
                    out.append("   -------  ");
                    out.append(nl);
                    out.append(" /   /   /  ");
                    out.append(nl);
                    out.append("+---+---+   ");
                    out.append(nl);
                    break;
                }
                if (this.rotation == Rotation.CLOCKWISE) {
                    out.append("    +---+---+");
                    out.append(nl);
                    out.append("   /   /   /");
                    out.append(nl);
                    out.append("   -------  ");
                    out.append(nl);
                    out.append(" / --->  /  ");
                    out.append(nl);
                    out.append("+---+---+   ");
                    out.append(nl);
                    break;
                }
                out.append("    +---+---+");
                out.append(nl);
                out.append("   /   /   /");
                out.append(nl);
                out.append("   -------  ");
                out.append(nl);
                out.append(" / <---  /  ");
                out.append(nl);
                out.append("+---+---+   ");
                out.append(nl);
                break;
            }
            case Z: {
                if (this.outerLayer == 0) {
                    if (this.rotation == Rotation.CLOCKWISE) {
                        out.append("+---+---+");
                        out.append(nl);
                        out.append("| <---  |");
                        out.append(nl);
                        out.append("+---+---+");
                        out.append(nl);
                        out.append("|   |   |");
                        out.append(nl);
                        out.append("+---+---+");
                        out.append(nl);
                        break;
                    }
                    out.append("+---+---+");
                    out.append(nl);
                    out.append("| --->  |");
                    out.append(nl);
                    out.append("+---+---+");
                    out.append(nl);
                    out.append("|   |   |");
                    out.append(nl);
                    out.append("+---+---+");
                    out.append(nl);
                    break;
                }
                if (this.rotation == Rotation.CLOCKWISE) {
                    out.append("+---+---+");
                    out.append(nl);
                    out.append("|   |   |");
                    out.append(nl);
                    out.append("+---+---+");
                    out.append(nl);
                    out.append("| <---  |");
                    out.append(nl);
                    out.append("+---+---+");
                    out.append(nl);
                    break;
                }
                out.append("+---+---+");
                out.append(nl);
                out.append("|   |   |");
                out.append(nl);
                out.append("+---+---+");
                out.append(nl);
                out.append("| --->  |");
                out.append(nl);
                out.append("+---+---+");
                out.append(nl);
                break;
            }
            default: {
                out.append("ERROR IN MOVEMENT");
            }
        }
        return out.toString();
    }

    @Override
    public void apply(Cube c) {
    }

    public int hashCode() {
        return this.axis.ordinal() + this.rotation.ordinal() * 10 + this.outerLayer * 100 + this.innerLayer * 1000;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoveRotate other = (MoveRotate)obj;
        return this.getAxis() == other.getAxis() && this.getRotation() == other.getRotation() && this.getInnerLayer() == other.getInnerLayer() && this.getOuterLayer() == other.getOuterLayer();
    }
}

