/*
 * Decompiled with CFR 0.152.
 */
import com.supermanhamuerto.rubik.Cube22;
import com.supermanhamuerto.rubik.CubeLoader;
import com.supermanhamuerto.rubik.MoveRotateXLeft;
import com.supermanhamuerto.rubik.MoveRotateXRight;
import com.supermanhamuerto.rubik.MoveRotateYLeft;
import com.supermanhamuerto.rubik.MoveRotateYRight;
import com.supermanhamuerto.rubik.MoveRotateZLeft;
import com.supermanhamuerto.rubik.MoveRotateZRight;
import com.supermanhamuerto.rubik.Movement;
import com.supermanhamuerto.rubik.Solver;
import java.io.Console;
import java.util.ArrayList;
import java.util.List;

public class App {
    public static List<Movement> getPossibleMovs() {
        ArrayList<Movement> result = new ArrayList<Movement>();
        result.add(new MoveRotateXLeft(0, 1));
        result.add(new MoveRotateXLeft(3, 2));
        result.add(new MoveRotateXRight(0, 1));
        result.add(new MoveRotateXRight(3, 2));
        result.add(new MoveRotateYLeft(0, 1));
        result.add(new MoveRotateYLeft(3, 2));
        result.add(new MoveRotateYRight(0, 1));
        result.add(new MoveRotateYRight(3, 2));
        result.add(new MoveRotateZLeft(0, 1));
        result.add(new MoveRotateZLeft(3, 2));
        result.add(new MoveRotateZRight(0, 1));
        result.add(new MoveRotateZRight(3, 2));
        return result;
    }

    public static void main(String[] args) {
        String cubeCorrect = "N";
        Cube22 currentCube = new Cube22();
        Console console = System.console();
        if (console == null) {
            System.err.println("No console.");
            System.exit(1);
        }
        do {
            System.out.println("How to read the cube:");
            System.out.println("");
            System.out.println("   1. put the rubik cube in front of you.");
            System.out.println("   2. read the colors of the TOP LAYER, ");
            System.out.println("      as if you were reading a book or a novel.");
            System.out.println("      If you have this:");
            System.out.println("      +---+");
            System.out.println("      |R|G|");
            System.out.println("      |Y|W|");
            System.out.println("      +---+");
            System.out.println("      You must enter the string \"rgyw\"");
            String face1 = console.readLine("", new Object[0]);
            System.out.println("   3. Now begin with the colors in front of you:");
            String face2 = console.readLine("", new Object[0]);
            System.out.println("   4. continue reading the colors of the face behind the cube");
            String face3 = console.readLine("", new Object[0]);
            System.out.println("   5. and then the colors in the face in the back of the cube");
            String face4 = console.readLine("", new Object[0]);
            System.out.println("   6. next, the rigth (your right, not the cube's) colors");
            String face5 = console.readLine("", new Object[0]);
            System.out.println("   7. and finnally, the colors of the left face ");
            String face6 = console.readLine("", new Object[0]);
            CubeLoader cubeLoader = new CubeLoader();
            cubeLoader.setFaces(currentCube, face1, face2, face3, face4, face5, face6);
            System.out.print(currentCube);
            MoveRotateXRight m1 = new MoveRotateXRight(0, 1);
            MoveRotateXRight m2 = new MoveRotateXRight(3, 2);
            m1.apply(currentCube);
            m2.apply(currentCube);
            System.out.print(currentCube);
        } while (!"y".equalsIgnoreCase(cubeCorrect = console.readLine("Is the cube correct (Y/n)?", new Object[0])) && !cubeCorrect.isEmpty());
        Solver solver = new Solver(currentCube, App.getPossibleMovs(), 10);
        if (solver.solve()) {
            List<Movement> solution = solver.getSolution();
            for (Movement mov : solution) {
                System.out.println(mov);
            }
        } else {
            System.out.println("no solution found");
        }
    }
}

