/*
 * Decompiled with CFR 0.152.
 */
package com.supermanhamuerto.rubik;

import com.supermanhamuerto.rubik.Cube;
import com.supermanhamuerto.rubik.Movement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class Solver {
    private Cube cube;
    private List<Movement> possibleMovs;
    private List<Movement> solution;
    private int depth;

    public Solver(Cube cube, List<Movement> possibleMovs, int depth) {
        this.cube = cube;
        this.possibleMovs = possibleMovs;
        this.depth = depth;
    }

    public List<Movement> getSolution() {
        return this.solution;
    }

    public boolean solve() {
        Stack<Cube> pastStates = new Stack<Cube>();
        this.solution = new ArrayList<Movement>();
        boolean isThereSolution = this.findSolution(pastStates, this.cube, this.solution, this.possibleMovs);
        if (isThereSolution) {
            Collections.reverse(this.solution);
            System.out.println("Solution found!!!");
        }
        return isThereSolution;
    }

    private boolean findSolution2(Stack<Cube> pastStates, Cube currentState, List<Movement> partialSolution, List<Movement> possibleMovs) {
        boolean solutionFound = currentState.isSolved();
        if (solutionFound) {
            return true;
        }
        if (pastStates.contains(currentState)) {
            return false;
        }
        if (pastStates.size() > this.depth) {
            return false;
        }
        pastStates.push(currentState);
        Iterator<Movement> itMov = possibleMovs.iterator();
        while (!solutionFound && itMov.hasNext()) {
            Movement currentMov = itMov.next();
            Cube temptativeSol = currentState.getCopy();
            currentMov.apply(temptativeSol);
            solutionFound = this.findSolution(pastStates, temptativeSol, partialSolution, possibleMovs);
            if (!solutionFound) continue;
            partialSolution.add(currentMov);
        }
        pastStates.pop();
        return solutionFound;
    }

    private boolean findSolution(Stack<Cube> pastStates, Cube currentState, List<Movement> partialSolution, List<Movement> possibleMovs) {
        boolean solutionFound = currentState.isSolved();
        if (solutionFound) {
            return true;
        }
        if (pastStates.contains(currentState)) {
            return false;
        }
        if (pastStates.size() > this.depth) {
            return false;
        }
        pastStates.push(currentState);
        Iterator<Movement> itMov = possibleMovs.iterator();
        while (!solutionFound && itMov.hasNext()) {
            Movement currentMov = itMov.next();
            Cube temptativeSol = currentState.getCopy();
            currentMov.apply(temptativeSol);
            solutionFound = this.findSolution(pastStates, temptativeSol, partialSolution, possibleMovs);
            if (!solutionFound) continue;
            partialSolution.add(currentMov);
        }
        pastStates.pop();
        return solutionFound;
    }
}

